﻿#########################
#
# Version 1.1 By Diagg | http://www.osd-couture.com
# Release Date 11/11/2016
# Version 1.3 by dpadgett | https://execmgr.net/
# Release Date 19/9/2017
# Thanks to Aida@Microsoft 
#
##== Refs
# XMl File
# https://support.microsoft.com/en-us/kb/2764405
# 
##== Keyboard ID
# https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-input-locales-for-windows-language-packs
#
##== Geo ID
# https://msdn.microsoft.com/en-us/library/dd374073.aspx
#########################

Write-Host '****************************************************'
Write-Host '**********Online Language Pack Injector*************'

##== Get MDT variables ($env:PSModulePath is requiered for SCCM CB and above... yet another regression from 2012R2...)
#$env:PSModulePath = $env:PSModulePath + ";C:\_SMSTaskSequence\WDPackage\Tools\Modules"
#Import-Module ZTIutility



##== Init 
$Global:CurrentScriptName = $MyInvocation.MyCommand.Name
$Global:CurrentScriptFullName = $MyInvocation.MyCommand.Path
$Global:CurrentScriptPath = split-path $MyInvocation.MyCommand.Path

#Setup TS Environment
try
    {
    $tsenv = New-Object -COMObject Microsoft.SMS.TSEnvironment
    }
catch
    {
	Write-Verbose "Not running in a task sequence."
    }

if ($tsenv)
    {
    $UIID = $tsenv.Value("SMSTS_WinSystemLocale") #Get Build Number from TS Variable.
    $KBID = $tsenv.Value("KeyboardLocale") #Get Build Number from TS Variable.
    $GeoID = $tsenv.Value("GEOID")
    }



$srcXML = @"
<gs:GlobalizationServices xmlns:gs="urn:longhornGlobalizationUnattend">
 
<!-- user list --> 
    <gs:UserList>
        <gs:User UserID="Current" CopySettingsToDefaultUserAcct="true" CopySettingsToSystemAcct="true"/> 
    </gs:UserList>

<!-- MUI preferences --> 
    <gs:MUILanguagePreferences>
        <gs:MUILanguage Value="$UIID"/>
        <gs:MUIFallback Value="en-US"/>
    </gs:MUILanguagePreferences>

<!-- system locale -->
    <gs:SystemLocale Name="$UIID"/>

<!--User Locale-->
    <gs:UserLocale> 
        <gs:Locale Name="$UIID" SetAsCurrent="true" ResetAllSettings="false"/>
    </gs:UserLocale>

<!--location--> 
 <gs:LocationPreferences> 
        <gs:GeoID Value="$GEOID"/> 
    </gs:LocationPreferences>

<!-- input preferences -->
    <gs:InputPreferences>
        <gs:InputLanguageID Action="add" ID="$KBID" Default="true"/>
        <gs:InputLanguageID Action="remove" ID="0409:00000409"/>
      </gs:InputPreferences>

</gs:GlobalizationServices>
"@

#Call ENBASE XML Formatting when language is En-*, we dont need to set a fallback language here. 
$srcXMLENBase = @"
<gs:GlobalizationServices xmlns:gs="urn:longhornGlobalizationUnattend">
 
<!-- user list --> 
    <gs:UserList>
        <gs:User UserID="Current" CopySettingsToDefaultUserAcct="true" CopySettingsToSystemAcct="true"/> 
    </gs:UserList>

<!-- system locale -->
    <gs:SystemLocale Name="$UIID"/>

<!--User Locale-->
    <gs:UserLocale> 
        <gs:Locale Name="$UIID" SetAsCurrent="true" ResetAllSettings="false"/>
    </gs:UserLocale>

<!--location--> 
 <gs:LocationPreferences> 
        <gs:GeoID Value="$GEOID"/> 
    </gs:LocationPreferences>

<!-- input preferences -->
    <gs:InputPreferences>
        <gs:InputLanguageID Action="add" ID="$KBID" Default="true"/>
        <gs:InputLanguageID Action="remove" ID="0409:00000409"/>
      </gs:InputPreferences>

</gs:GlobalizationServices>
"@

#Fixes a bug in Windows 10 creators update where default keyboard on the welcome screen is not set. 
$AddUSKBD = @"
<gs:GlobalizationServices xmlns:gs="urn:longhornGlobalizationUnattend">
<!-- user list --> 
    <gs:UserList>
        <gs:User UserID="Current" CopySettingsToDefaultUserAcct="true" CopySettingsToSystemAcct="true"/> 
</gs:UserList>
<!-- input preferences -->
    <gs:InputPreferences>
        <gs:InputLanguageID Action="add" ID="0409:00000409"/>
      </gs:InputPreferences>

</gs:GlobalizationServices>
"@

<# - have seperate TS Step for this, skipping this part of script.

##== Inject Languages Packs
## option to add /Quiet switch to dism to reduce smsts.log spam
$Files = Get-ChildItem $tsenv:LPDownloadPath01 -Recurse
write-host "Custom path var is: $tsenv:LPDownloadPath01"
write-host "Files found are: $tsenv:LPDownloadPath01"
#Note 'Download Package Content Step 'Save as var' will append numerical code to declared var (01)
Foreach	($file in $Files)
	{
		If ($File.extension.ToUpper() -eq ".CAB")
			{
				Write-Host ('intjecting package ' + $file.fullname)
				$command = "dism /online /add-package /PackagePath:" + $file.fullname
				Invoke-Expression $command
			}
	}
 #>

##== Edit XML
$destXML = "C:\Windows\Temp\UI-Settings.xml"
$destXML2 = "C:\Windows\Temp\UI-Settings-USKBD.xml"

$VarNameLng = '$UIID'
Write-Host ('value read from tsenv:UILanguage : ' + $tsenv:UILanguage)
$lng = $tsenv:UILanguage
Write-Host ('Promoted UI:' + $lng)

$VarNameKB = '$KBID'
Write-Host ('value read from tsenv:KeyboardLocale : ' + $tsenv:KeyboardLocale)
$KB = $tsenv:KeyboardLocale

$VarNameGEO = '$GEOID'
Write-Host ('value read from tsenv:GeoID : ' + $tsenv:GeoID)
$GEO = $tsenv:GeoID


##== Quick Fix for an UDI bug that cast out truncated Keyboard ID
$KBdigit=$KB.substring(9,4)
$KB = ($KBdigit + ":0000" + $KBdigit)
Write-Host ('Promoted Keyboard:' + $KB)

##== Set Selected Language as the default UI
if ($lng -like 'en-*') {
$content = $srcXMLENBase -replace $VarNamelng, $lng
}
else 
{
$content = $srcXML -replace $VarNamelng, $lng
}

$content = $content -replace $VarNameKB, $KB
$content = $content -replace $VarNameGEO, $GEO

Write-Host ("Creating XML language file in " + $destXML)
Out-File $destXML -InputObject $content

Write-Host ("Creating XML language file for USKBD " + $destXML2)
Out-File $destXML2 -InputObject $AddUSKBD

Write-Host 'Online Language Pack injection finished !!'
Write-Host '****************************************************'